// Generate AI insights for mood entries using OpenAI
export async function POST(request) {
  try {
    const body = await request.json();
    const { journalEntry, moodLabel, recentMoods } = body;

    if (!journalEntry) {
      return Response.json(
        { success: false, error: "Journal entry is required" },
        { status: 400 },
      );
    }

    // Build context for AI
    let contextMessage = `You are a supportive mental health companion. Analyze this journal entry and provide empathetic, constructive insights.

Current mood: ${moodLabel}
Journal entry: ${journalEntry}`;

    if (recentMoods && recentMoods.length > 0) {
      contextMessage += `\n\nRecent mood history: ${recentMoods.join(", ")}`;
    }

    contextMessage += `\n\nProvide a brief, supportive insight (2-3 sentences) that:
1. Acknowledges their feelings
2. Offers a positive perspective or actionable tip
3. Is warm and encouraging`;

    const response = await fetch("/integrations/chat-gpt/conversationgpt4", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify({
        messages: [
          {
            role: "user",
            content: contextMessage,
          },
        ],
      }),
    });

    if (!response.ok) {
      throw new Error(`AI request failed: ${response.statusText}`);
    }

    const data = await response.json();
    const insight = data.choices[0].message.content;

    return Response.json({ success: true, insight });
  } catch (error) {
    console.error("Error generating mood insight:", error);
    return Response.json(
      { success: false, error: error.message },
      { status: 500 },
    );
  }
}
